function [vad] = File_Cleaner_V2(lidar,Max_Velocity,SNR_CutOff)
% ==================================================================
%
%	MATLAB m-file for Filtering Lidar Data (Radial Velocity, BackScatter)
%				
%				Jason Porter
%				ASU
%			    Dec 2002
%
%	INPUT:	 Data, Header, Sweep ID
%
%	OUTPUT:	 Filtered Data
%
% ========================================================
vad=lidar;
prop=diff(lidar.RWS,1,2);
[inda,indb]=find(abs(prop)>=10);
vad.RWS(abs(lidar.RWS)>15)=-999;
vad.RWS(inda,indb)=-999;
%hard target
% [nang,nr]=size(vad.SNR);
% for j=1:nang
%     meanSNR=mean(vad.SNR(j,:));
%     [locs pks]=peakseek(vad.SNR(j,:),5,5*meanSNR);
%     hard=locs(1);
%         vad.SNR(j,hard:end)=-999;
%         vad.RWS(j,hard:end)=-999;
%         vad.Beta(j,hard:end)=-999;
% end
uu=find(vad.SNR < SNR_CutOff & abs(vad.RWS) < Max_Velocity);

vad.SNR(uu)=NaN;
vad.RWS(uu)=NaN;
vad.Beta(uu)=NaN;
return
end




